% MATLAB code: Example 11.6, Table 11.2 columns 3-6
% File: scoretest.m
%
% SCORETEST STATISTICS
% After Yukai Yang's R-code (see Exercise 11.5c for R code; scoretest.r)
%
% TEST: LINEARITY versus LVSTAR(p) model with dim m = 2 and
%       for TT.dat a (66 * 2) matrix
% 
% INPUT:
% mE = Matrix of residuals from VAR(p)-fit (For TT.dat, p = 4) 
% mX = Matrix of regressors 
% mZ = Auxiliary regression matrix, with
%      mZd1 = delay d=1; mZd2 = delay d=2; mZd3 = delay d=3;
%      mZd4 = delay d=4; and mZd5 = delay d=5.
% NOTE: All the above data matrices are stored in the file: 
%       data-example_11-6 
%
% OUTPUT: 
% LM test first-order
% F test (rescaled LM test)
% Wilks' test with Barlett's correction
% Wilks' test with Rao's F approximation
%
% DATA: TT.dat (tree widths: temperature Y_{1,t} and ring widths Y_{2,t})
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Initialize, change delay lag d, skip this part in final analysis
%% [iT,ip]   = size(TT);
%% lag       = 5;   % delay lag d: change this part !!!!!!!!!!!!!!!!!!!
%% XLAGall   = lagmatrix(TT,[1:lag]);   % lagmatrix in Econometrics toolbox
%% XLAGclean = XLAGall(lag+1:iT,:);     % remove first "lag" rows with zeros
%% XLAGclean = mX;
%% iTn       = iT-lag;
%% for i=1:iTn
%%    mZd1(i,:) = XLAGclean(i,:)'.*XLAGclean(i,1);  % delay lag d = 1 temp
%%    mZd2(i,:) = XLAGclean(i,:)'.*XLAGclean(i,3);  % delay lag 2 temp
%%    mZd3(i,:) = XLAGclean(i,:)'.*XLAGclean(i,5);  % delay lag 3 temp
%%    mZd4(i,:) = XLAGclean(i,:)'.*XLAGclean(i,7);  % delay lag 4 temp
%%    mZd5(i,:) = XLAGclean(i,:)'.*XLAGclean(i,9);  % delay lag 5 temp
%% end;
%% mZ = mZd5;   % change this part for each value of d !!!!!!!!!!!!!!!!!!!!!! 
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [score] = scoretest(mE,mX,mZ)

[iT,ip]    = size(mE);
[~,ix]     = size(mX);    
[~,iz]     = size(mZ);
iK         = ix+iz;
iDF        = iz*ip;
RSS0       = mE'*mE;
mXX        = [mX,mZ];

[mU,~,~]   = svd(mXX,0);  % 0 produces the "economy size" decomposition 
ZZ         = mU*mU';
mR         = mE - ZZ*mE;
RSS1       = mR'*mR;

[~,mRV,~]  = svd(RSS0,0);   
[~,mR1V,~] = svd(RSS1,0);
R0         = mRV;
R1         = mR1V;

dTR      = sum(trace(inv(RSS0)*RSS1));
test     = iT*(ip-dTR);
LMpval   = 1 - chi2cdf(test,iDF);
LMtest   = test;
LMdf     = iDF;

%%%  rescale test, FT = [(iT-iK)/(iT*LMdf)]*LMtest with LMdf = iDF = iz*ip
iDF1     = iDF;
iDF2     = ip*(iT-iK);
test     = LMtest * (iT-iK) / (iT*LMdf);
FTpval   = 1 -fcdf(test,iDF1,iDF2);
% FTdf1  = iDF1;
% FTdf2  = iDF2;

%%% Wilks' test with Barlett's approximation
Lambda   = trace(log(R1)) - trace(log(R0));
Lambda   = Lambda * ((ip+iz+1)*.5 + ix -iT);
WKpval   = 1 - chi2cdf(Lambda,iDF);
WKtest   = Lambda;
% WKdf   = iDF;

%%% Wilks' test with Raos aprpoximation
iN       = iT-ix-(ip+iz+1)*.5;
is       = sqrt((iz*iz*ip*ip-4)/(ip*ip+iz*iz-5) );
iDF1     = iDF;
iDF2     = iN*is - iz*ip*.5 + 1;
RAO      = exp((trace(log(R0))-trace(log(R1)))/is)-1;
RAO      = RAO *iDF2 /iDF1;
RAOpval  = 1-fcdf(RAO,iDF1,iDF2);
RAOtest  = RAO;
% RAOdf1 = iDF1;
% RAOdf2 = iDF2;

disp('LM-test, LM-pval, FT-test, FT-pval, WK-test, WK-pval, Rao-Test, Rao-pval') 
score = [LMtest, LMpval, test, FTpval, WKtest, WKpval, RAOtest, RAOpval];

% disp('Degrees of freedom: LM-df,  FT-df1, FT-df2, WKdf, RAO-df1, RAO-df2')
% DF = [LMdf, FTdf1, FTdf2, WKdf, RAOdf1, RAOdf2];
